/*
* ColecoDiag.cpp
*
* Created: 11/28/2019 1:00:50 AM
*/

#include <avr/io.h>
#include <stdio.h>
#include "Serial.h"
#include "Common.h"
#include "ColecoDiag.h"

Serial serial = {
	0
};

static int serial_putchar( char c, FILE *f )
{
	serial_putonechar( c, fdev_get_udata( f ) );
	return 0;
}

static int serial_getchar( FILE *f )
{
	return serial_readonechar( fdev_get_udata( f ) );
}

static FILE iostream = FDEV_SETUP_STREAM( serial_putchar, serial_getchar, _FDEV_SETUP_RW );

int main(void)
{
	serial_init( 115200, &serial );
	fdev_set_udata( &iostream, &serial );
	stdout = &iostream;
	stdin = stdout;
	
	analogSetup();
	
	setup();
	
	/* Replace with your application code */
	while (1)
	{
		loop();
	}
}

